
#ifndef __AIVEXMAGICARIOS_H__
#define __AIVEXMAGICARIOS_H__
#import <Foundation/Foundation.h>


/**
 Define touch event type

 - MagicARTouchUnknown: unknown
 - MagicARTouchPress: press event
 - MagicARTouchMove: move event
 - MagicARTouchRelease: release event
 */
typedef NS_ENUM(NSInteger, MagicARTouchType) {
    ///unknown
    MagicARTouchUnknown,
    /// press event
    MagicARTouchPress,
    /// move event
    MagicARTouchMove,
    /// release event
    MagicARTouchRelease
};

typedef NS_ENUM(NSInteger, MagicARRenderObjectType) {
    /// 3D model node
    MagicARRenderObjectEntity = 1,
    /// 2D image node
    MagicARRenderObjectImage,
    /// 2D video node
    MagicARRenderObjectVideo
};

@interface MagicAR : NSObject

/**
 initialize

 @return an MagicAR instance
 */
- (id)init;


/**
 Destroy all, must invoke manually
 */
- (void)destroyAll;


/**
 Set display view resolution

 @discuss This function should be invoked before view update draw
 @param width view width in pixel
 @param height view height in pixel
 */
- (void)displayResolution:(int) width HEIGHT:(int) height;

/**
 update render
 */
- (void)update;

/**
 pause rendering
 */
- (void)pause;

/**
 resume rendering
 */
- (void)resume;

/**
 show AliGenie AR watermask or not

 @param show show or hide
 */
- (void)setShowWaterMask:(BOOL)show;

/**
 Set the Asset.bin path
 
 @discuss This should be absolute path
 @param path absolute path
 */
- (void)setAppAssetsPath:(const char*)path;
/**
 *  set the interact permission
 *
 * @param flag The permission flag
 *       bit: 0  Translate,
 *       bit: 1  Rotate,
 *       bit: 2  Scale,
 *
 */
- (void)setTouchType:(uint)flag;



/**
 Create render object

 @param id render object id
 @param type render object type
 @param x top-left x
 @param y top-left y
 @param width width
 @param height height
 @param path when type is MagicARRenderObjectEntity needs to set
 @return success or fail
 */
- (BOOL)createObject:(const char*)id
                Type:(MagicARRenderObjectType) type
                   X:(float) x
                   Y:(float) y
               Width:(float) width
              Height:(float) height
                PATH:(const char*) path;


/**
 Delete render object

 @param id render object id
 */
- (void)deleteObject: (const char*) id;

/**
 Set render object visible or invisible

 @param id render object id
 @param visible visible or invisible
 */
- (void)setObjectVisible: (const char*) id visible:(BOOL)visible;


/**
 Reset scene
 */
- (void)resetScene;

/**
 Set view params

 @param eye eye vector
 @param target target vector
 @param up up vector
 */
- (void)setViewParams: (float*) eye Target:(float*) target Up:(float*) up;
- (void)setViewMatrix: (float*) mat;

/**
 Set projection params

 @param fov Field Of View
 @param near near plane
 @param far far plane
 */
- (void)setProjection: (float) fov Near:(float) near Far:(float) far;
- (void)setProjectionMatrix: (float*) mat;
/**
 Feed the live camera data

 @param data YUV data start address
 @param stride bytes per row
 @param width width
 @param height height
 */
- (void)setCameraData: (unsigned char*) data
               Stride: (int) stride
                Width: (int) width
               Height: (int) height;


/**
 Update camera data

 @param orientation orientation
 @param stride bytes per row
 @param width width
 @param height height
 @return success or fail
 */
- (BOOL)updateCameraParams:(int)orientation
                     stride:(int)stride
                      width:(int)width
                     height:(int)height;

/**
 *  create the bubble text animation
 */
- (void)createBubble;

/**
 *  destroy the bubble target
 */
- (void)destroyBubble;

/**
 *  update a text to be show, it will update to looped target
 */
- (void)updateBubbleText:(unsigned char*)data andWidth:(unsigned int)width andHeight:(unsigned int)height;

/**
 *  update a text to be show, it will update to looped target
 */
- (void)setBubbleAnchorPosWithX:(int)x andY:(int)y;

/**
 *  achieve bubble count
 */
- (unsigned int)getBubbleCount;

/**
 *  udpate the object transform
 *
 * @param id The object id.
 * @param transform The transform to be set to object
 */
- (BOOL)updateObjectTransform:(const char*)id Transfrom:(float*)transform;

/**
 update image data
 
 @param id image node id
 @param data source data
 @param width width
 @param height height
 @return texture id
 */
- (int)updateImageData:(const char*)id Data:(unsigned char*)data Width:(int)width Height:(int)height;

/**
 update video data
 
 @param id image node id
 @param data source data
 @param width width
 @param height height
 @return texture id
 */
- (int)updateVideoData:(const char*)id Data:(unsigned char*)data Width:(int)width Height:(int)height;

/**
 Touch event dispatcher, This will call Platform::touchEventInternal function

 @param type event type
 @param x point x
 @param y point y
 @param cIdx index
 */
- (void)touchEventInternal:(MagicARTouchType)type x:(int)x y:(int)y contactIndex:(unsigned int)cIdx;


/**
 Handler when track losts
 */
- (void)handleTrackLost:(int)mode;

@end
/**
 使用iOS的NSNotificationCenter通知消息notify，在客户端ARCoreScene中监听消息@"MagicARiOS.postObjectNotification"
 并分析获取到id
 
 @param notify 消息内容
 */
void postObjectNotification(const char*notify);

#endif
