//
//  ARCoreDelegate.h
//  ARCore
//
//  Created by jefby on 16/12/28.
//  Copyright © 2016年 人工智能实验室. All rights reserved.
//

#import <Foundation/Foundation.h>

@protocol AGARCoreDelegate <NSObject>

@optional

/**
 识别到的2D marker Id, 会根据识别追踪结果进行更新
 */
@property (nonatomic, copy) NSString* objectId;

/**
 识别到的3D 物体Id, 会根据识别追踪结果进行更新
 */
@property (nonatomic, copy) NSString* object3DId;

/**
 接管URL内容展示，默认会调用系统的API, 即使用safari打开链接
 
 @param url resource url
 */
- (void)onOpenURL:(NSString *)url;

/**
 2D marker追踪成功时的代理函数, 此时marker对应的id为@property objectId,
 用户可以根据此id做对应的业务逻辑
 */
- (void)onObjectTracked;

/**
 2D marker追踪丢失时的代理函数, 目前有一些固有的逻辑:
 例如如果场景中有3D模型, sdk默认会调用rescanClick函数
 */
- (void)onObjectTrackLost;


/**
 3D 物体追踪成功时的代理函数, 此时物体对应的id为@property object3DId,
 用户可以根据此id做对应的业务逻辑
 */
- (void)onObject3DTracked;

/**
 3D 物体追踪丢失时的代理函数
 */
- (void)onObject3DTrackLost;

/**
 重扫时会调用，可以重新设置Focus Region位置信息等
 */
- (void)onRescan;

/**
 当用户拒绝授权给相机时的回调函数, 用户可以在这里显示自定义的提示框
 如果实现了该接口, 则必须在[super viewDidLoad]前设置delegate
 */
- (void)onUserDenyCameraAuthorization;


/**
 当检测到二维码时的回调函数, 目前只支持检测一个二维码
 注意: 需要设置enableDetectQRCode为YES
 
 @param result QRCode result
 */
- (void)onDetectQRCode:(NSString*)result;

@end
