//
//  DetectedObject.h
//  SmartStore
//
//  Created by xhw on 18/07/2017.
//  Copyright © 2017 alibaba. All rights reserved.
//

#ifndef DetectedObject_h
#define DetectedObject_h

#include <cmath>
#include <string.h>
class DetectedObject
{
    
public:
    enum TrackingState
    {
        NONE=0,
        DETECTION=1,
        TRACKING=2,
        RELOCALIZATION=3
    };
public:
    DetectedObject()
    {
        label_[0]='\0';
    }
    DetectedObject(int category,const char* label,int64_t timestamp,float left,float top,float right,float bottom,TrackingState state):category_(category),timestamp_(timestamp),
    left_(left),top_(top),right_(right),bottom_(bottom),state_(state){
        strcpy(label_, label);
    }
    
    inline void UpdatePosition(float left,float top,float right,float bottom)
    {
        left_=left;
        right_=right;
        top_=top;
        bottom_=bottom;
    }
    
    inline void UpdatePosition(const DetectedObject &other)
    {
        left_=other.left_;
        top_=other.top_;
        right_=other.right_;
        bottom_=other.bottom_;
    }
    
    inline float intersectionArea(const DetectedObject &other) const
    {
        float minX=fmax(left_,other.left_);
        float maxX=fmin(right_,other.right_);
        float minY=fmax(top_,other.top_);
        float maxY=fmin(bottom_,other.bottom_);
        if(minX>maxX) return 0;
        if(minY>maxY) return 0;
        return (maxX-minX)*(maxY-minY);
    }
    
    inline float unionArea(const DetectedObject &other) const
    {
        return area()+other.area()-intersectionArea(other);
    }
    
    inline float area() const
    {
        return (bottom_-top_+1)*(right_-left_+1);
    }
    
    //升序排列
    bool operator <(const DetectedObject &other) const
    {
        return area()>other.area();
    }
    //降序排列
    bool operator > (const DetectedObject &other) const
    {
        return area()>other.area();
    }
    
public:
    int category_;
    int64_t timestamp_;
    float left_;
    float top_;
    float right_;
    float bottom_;
    char label_[256];
    TrackingState state_;

    
};

#endif /* DetectedObject_h */
