//
//  AIR_ObjectDetection.hpp
//  SmartStore
//
//  Created by xhw on 03/08/2017.
//  Copyright © 2017 alibaba. All rights reserved.
//

#ifndef AIR_ObjectDetection_hpp
#define AIR_ObjectDetection_hpp

#include <stdio.h>
#include <vector>

#include "DetectedObject.h"

typedef long long int64_t;
typedef unsigned char uchar;

//启动识别
//参数：path为检测模型文件所在的路径
//成功返回1，否则返回对应错误代码：-1，ModleConfig没有配置或路径找不到；-2，ModelConfig格式有误
int AIR_Start(const char* path);
//停止识别
//参数：void
//成功返回1，否则返回0
int AIR_Stop();
//目标检测
//参数：imageGray,输入图像帧的灰度图, imageWidth, imageHeight, 长宽推荐使用640*480； timestamp, 时间戳；output，返回的目标结果
//识别到目标返回1，否则返回0，检测到的目标信息通过output参数返回
int AIR_Detect(uchar* imageGray,int imageWidth, int imageHeight, int64_t timestamp, std::vector<DetectedObject> &output);
//重置所有状态，清理内部缓存；应用进入后台，再次被唤醒时，类似的情况下可以调用
//参数：null
//成功返回1，失败返回0
int AIR_Reset();

//目标检测
//参数：imageGray,输入图像帧的灰度图, imageWidth, imageHeight, 长宽推荐使用640*480； timestamp, 时间戳；output，返回的目标结果
//识别到目标个数，否则返回0，检测到的目标信息通过output参数返回
int AIR_Detect(uchar* imageGray,int imageWidth, int imageHeight, int64_t timestamp,DetectedObject outputs[]);

//设置检测结果，服务端返回结果后，可以使用该方法更新BoundingBox的位置
//参数 DetectedObject实例
//返回 设置成功返回1，同时会更新obj的信息（Track），否则返回0,
int AIR_SetDetectObjectPosition(DetectedObject &obj,uchar* imageGray,int imageWidth, int imageHeight);


/*********************************************************************
设置参数（应该在AIR_Start()之前调用）
********************************************************************/
//设置跟踪使用的Frame大小，默认值320*240
//参数: frameWidth 宽，frameHeight 高
//成功返回1，否则返回0
int AIR_SetTrackingFrameSize(int frameWidth,int frameHeight);


//设置每帧最多检测到的目标数量，默认值是2
//参数：num, 设置的每帧检测到目标物体的数量上限
//成功返回1，否则返回0
int AIR_SetMaxDetectObjects(int num);

//设置目标所在BoundingBox的最小值,小于size*size的目标会被抛弃，默认为100像素
//参数：size,BoundingBox的边长
//成功返回1，否则返回0
int AIR_SetMinBoundingBox(int size);

//关闭Tracking功能，默认是开启状态
//参数：void
//成功返回1，否则返回0
int AIR_DisableTracking();

//开启Tracking功能
//参数：void
//成功返回1，否则返回0
int AIR_EnableTracking();

//关闭Feature重定位功能
//参数：void
//成功返回1，失败返回0
int AIR_DisableFeatureRelocalization();

//开启Feature重定位功能
//参数：void
//成功返回1，失败返回0
int AIR_EnableFeatureRelocalization();

//设置重定位尝试时长，默认3s
//参数：void
//成功返回1，失败返回0
int AIR_SetFeatureRelocalizationTime(int sec);

//开启客户端检测功能，默认开启
//参数:void
//成功返回1，失败返回0
int AIR_EnableDetection();

//关闭客户端检测功能
//参数:void
//成功返回1，失败返回0
int AIR_DisableDetection();

//计算图像清晰度评分
//参数:imageGray,输入图像帧的灰度图, imageWidth, imageHeight,图像宽和高
//返回评分值，数值越大，表示清晰度越高
double AIR_ImageBlurScore(unsigned char* imageGray,int imageWidth,int imageHeight);

#endif /* AIR_ObjectDetection_hpp */
