//
//  ViewController.m
//  AGARCoreDemo
//
//  Created by jefby on 2017/11/7.
//  Copyright © 2017年 jefby. All rights reserved.
//

#import "ViewController.h"
#import <AVFoundation/AVFoundation.h>

NSTimeInterval gEndTime = 0;

extern NSTimeInterval gStartTime;

@interface ViewController ()

@end


@implementation ViewController{
    UIView *_topBarView;
    UIButton *_returnBtn;
    UIButton *_lightBtn;
    // 当前闪光灯是打开还是关闭
    BOOL _flashLightIsOpen;
    
    UIImage *_lightOpenImg;
    UIImage *_lightCloseImg;
}

- (void)viewDidLoad {
    // IMPORTANT:
    // 注意：这里设置appKey，secret必须在[super viewDidLoad]之前调用
    // 请设置为在http://open.taobao.com上申请的appkey和secret
//    self.appKey = @"xxxx";
//    self.secret = @"xxxx";
    

    [super viewDidLoad];
 
    // 设置代理为self
    self.delegate = self;
    
    // setup top bar
    [self setupTopBar];
    
    // 开始追踪
    [self startObjectTracking];
   

}

- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
    
    [self setupTopBar];
}

- (void)viewDidAppear:(BOOL)animated
{
    [super viewDidAppear:animated];
    
    gEndTime = [[NSDate date] timeIntervalSince1970] * 1000;
    NSLog(@"camera open takes %f ", gEndTime - gStartTime);
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

#pragma mark - UI

/**
 初始化顶层Bar
 */
- (void)setupTopBar
{
    if (_topBarView) {
        return;
    }
    // 顶层View，用于在识别然后移动到屏幕后显示
    CGRect statusBarRect = [[UIApplication sharedApplication] statusBarFrame];
    _topBarView = [[UIView alloc] initWithFrame:CGRectMake(0, statusBarRect.size.height, self.view.frame.size.width, 80)];
  
    // return按键
    _returnBtn = [UIButton buttonWithType:UIButtonTypeCustom];;
    [_returnBtn setFrame:CGRectMake(2, 2, 40, 40)];
    [_returnBtn setContentHorizontalAlignment:UIControlContentHorizontalAlignmentCenter];
    [_returnBtn addTarget:self action:@selector(handleBtnTapped:) forControlEvents:UIControlEventTouchUpInside];
    UIImage *rtnImg = [UIImage imageNamed:@"return@3x.png"];
    [_returnBtn setImage:rtnImg forState:UIControlStateNormal];
    [_topBarView addSubview:_returnBtn];

    
    // flash按键
    _lightBtn = [UIButton buttonWithType:UIButtonTypeCustom];;
    [_lightBtn setFrame:CGRectMake(self.view.frame.size.width - 10 - 40, 2, 40, 40)];
    [_lightBtn setContentHorizontalAlignment:UIControlContentHorizontalAlignmentCenter];
    [_lightBtn addTarget:self action:@selector(handleBtnTapped:) forControlEvents:UIControlEventTouchUpInside];
    _lightCloseImg = [UIImage imageNamed:@"flashlight_close@3x.png"];
    _lightOpenImg = [UIImage imageNamed:@"flashlight_open@3x.png"];
    [_lightBtn setImage:_lightCloseImg forState:UIControlStateNormal];
    [_topBarView addSubview:_lightBtn];
    
    [self.view addSubview:_topBarView];
}

#pragma mark - Event Handler
- (void)handleBtnTapped:(id)sender
{
    if (sender == _returnBtn) {
        // 根据跳进来的方式自己调整代码
        [self destroyAll];
        [self.navigationController popViewControllerAnimated:YES];
    }else if(sender == _lightBtn) {
        _flashLightIsOpen = !_flashLightIsOpen;
        if (_flashLightIsOpen) {
            [self setFlashLight:AVCaptureTorchModeOn];
            [_lightBtn setImage:_lightOpenImg forState:UIControlStateNormal];
        }else{
            [self setFlashLight:AVCaptureTorchModeOff];
            [_lightBtn setImage:_lightCloseImg forState:UIControlStateNormal];
        }
    }
}
#pragma mark - AGARCoreDelegate Implemention

// 2D marker追踪成功的代理函数
- (void)onObjectTracked
{
    NSLog(@"%s objectId : %@", __func__, self.objectId);
}

// 2D marker追踪丢失的代理函数
- (void)onObjectTrackLost
{
    NSLog(@"%s objectId : %@", __func__, self.objectId);
    [_topBarView setHidden:YES];
}

- (void)onObject3DTracked
{
}

- (void)onObject3DTrackLost
{
}

// 重扫时的回调函数
- (void)onRescan
{
    NSLog(@"%s", __func__);
    [_topBarView setHidden:NO];
}

// 打开链接回调函数, 如果定义了该函数, 需要自己去处理如何显示url内容
//- (void)onOpenURL:(NSString *)url
//{
//    NSLog(@"%s", __func__);
//    /// 使用safari打开
//    if (!url) {
//        return;
//    }
//
//    NSURL *urlObj = [NSURL URLWithString:url];
//    BOOL result = [[UIApplication sharedApplication] canOpenURL:urlObj];
//
//    if (result == YES) {
//        [[UIApplication sharedApplication] openURL:urlObj];
//    }
//}

#pragma mark - Utils

// 打开或关闭闪光灯
- (void)setFlashLight:(AVCaptureTorchMode)mode
{
    AVCaptureDevice * device = [AVCaptureDevice defaultDeviceWithMediaType:AVMediaTypeVideo];
    if ([device hasTorch]) {
        [device lockForConfiguration:nil];
        [device setTorchMode:mode];
        [device unlockForConfiguration];
    }
}

- (void)dealloc
{
    NSLog(@"%s ~~~~~", __func__);
}
@end
