//
//  MainViewController.m
//  AGARCoreDemo
//
//  Created by jefby on 2017/12/11.
//  Copyright © 2017年 jefby. All rights reserved.
//

#import "MainViewController.h"
#import "ViewController.h"

@interface MainViewController ()

@end

NSTimeInterval gStartTime = 0;

@implementation MainViewController {
    BOOL _showAR;
}

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any aradditional setup after loading the view.
    [self addShowButton];
}

- (void)viewDidDisappear:(BOOL)animated
{
    [super viewDidDisappear:animated];
    
    _showAR = NO;
}

- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
    
    _showAR = NO;
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

- (void)addShowButton
{
    UIButton *showBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    [showBtn setContentHorizontalAlignment:UIControlContentHorizontalAlignmentLeft];
    [showBtn setContentVerticalAlignment:UIControlContentVerticalAlignmentTop];
    [showBtn setTitleColor:[UIColor redColor] forState:UIControlStateNormal];
    UIImage *imageScan = [UIImage imageNamed:@"scan.png"];
    [showBtn setImage:imageScan forState:UIControlStateNormal];
    [showBtn addTarget:self action:@selector(handleShowButtonPressed:) forControlEvents:UIControlEventTouchUpInside];
    showBtn.frame = CGRectMake(20, 100, 40, 40);
    [self.view addSubview:showBtn];
}

- (void)handleShowButtonPressed:(id)sender
{
    if (!_showAR) {
        _showAR = YES;
    }else{
        return;
    }
    AGARCoreUtils *agarUtils = [AGARCoreUtils new];
    
    // 检测当前设备是否支持AR功能
    if ([agarUtils arFeatureIsSupported]) {
        gStartTime = [[NSDate date] timeIntervalSince1970] * 1000;
        NSLog(@"startTime is %f ", gStartTime);
        ViewController *vc = [ViewController new];
        if ([vc canPresent]) {
            [self.navigationController setNavigationBarHidden:YES];
            [self.navigationController pushViewController:vc
                                                 animated:YES];
        }else{
            _showAR = NO;
        }
      
    }else{
        UIAlertController* alert = [UIAlertController alertControllerWithTitle:@"AGAR SDK"
                                                                       message:@"不支持该手机."
                                                                preferredStyle:UIAlertControllerStyleAlert];
        
        UIAlertAction* defaultAction = [UIAlertAction actionWithTitle:@"OK" style:UIAlertActionStyleDefault
                                                              handler:^(UIAlertAction * action) {}];
        
        [alert addAction:defaultAction];
        
        _showAR = NO;

        [self presentViewController:alert animated:YES completion:nil];
    }
  
}
/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
